@extends('layouts.admin')

@section('title', 'Edit Forum Board')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-card dashboard-card-full">
        <div class="dashboard-card-header">
            <h3>Edit Forum Board</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.forum.boards.update', $board) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="form-group">
                    <label for="category_id">Category</label>
                    <select name="category_id" id="category_id" class="form-control @error('category_id') has-error @enderror" required>
                        <option value="">Select Category</option>
                        @foreach($categories as $id => $name)
                            <option value="{{ $id }}" {{ (old('category_id', $board->category_id) == $id) ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                    @error('category_id')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="name">Board Name</label>
                    <input type="text" name="name" id="name" class="form-control @error('name') has-error @enderror" value="{{ old('name', $board->name) }}" required>
                    @error('name')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea name="description" id="description" class="form-control @error('description') has-error @enderror">{{ old('description', $board->description) }}</textarea>
                    @error('description')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="order">Display Order</label>
                    <input type="number" name="order" id="order" class="form-control @error('order') has-error @enderror" value="{{ old('order', $board->order) }}" min="0" required>
                    @error('order')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                {{-- Access Control Section --}}
                <div class="forum-access-control forum-access-control--board">
                    <div class="forum-access-control__header">
                        <h5 class="forum-access-control__title">Board Access Control Settings</h5>
                        <div class="forum-access-control__subtitle">
                            Note: Users must also have access to the parent category
                        </div>
                    </div>
                    <div class="forum-access-control__body">
                        <div class="forum-access-control__public-toggle">
                            <input type="checkbox" class="form-check-input" id="is_public" name="is_public" 
                                   value="1" {{ old('is_public', $board->is_public) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_public">
                                <strong>Public Board</strong> (inherits category access only)
                            </label>
                            <div class="forum-access-control__help-text">
                                If unchecked, additional role/permission requirements apply
                            </div>
                        </div>
                        
                        <div id="access-controls" class="forum-access-control__restricted" style="{{ old('is_public', $board->is_public) ? 'display: none;' : '' }}">
                            <div class="forum-access-control__inheritance-notice">
                                <strong>Access Logic:</strong> Users need access to the parent category AND meet these additional requirements.
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="required_roles">Additional Required Roles</label>
                                        <select multiple class="form-control forum-access-control__select @error('required_roles') has-error @enderror" 
                                                id="required_roles" name="required_roles[]" size="5">
                                            @foreach($roles as $role)
                                                <option value="{{ $role->name }}" 
                                                        {{ in_array($role->name, old('required_roles', $board->required_roles ?? [])) ? 'selected' : '' }}>
                                                    {{ ucfirst($role->name) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="forum-access-control__help-text">
                                            Users need at least ONE of these roles (hold Ctrl to select multiple)
                                        </div>
                                        @error('required_roles')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="required_permissions">Additional Required Permissions</label>
                                        <select multiple class="form-control forum-access-control__select @error('required_permissions') has-error @enderror" 
                                                id="required_permissions" name="required_permissions[]" size="5">
                                            @foreach($permissions as $permission)
                                                <option value="{{ $permission->name }}" 
                                                        {{ in_array($permission->name, old('required_permissions', $board->required_permissions ?? [])) ? 'selected' : '' }}>
                                                    {{ ucfirst(str_replace('-', ' ', $permission->name)) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="forum-access-control__help-text">
                                            Users need ALL of these permissions
                                        </div>
                                        @error('required_permissions')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-check mt-3">
                    <input type="checkbox" name="is_active" id="is_active" value="1" {{ $board->is_active ? 'checked' : '' }}>
                    <label for="is_active">Active</label>
                </div>
                
                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary">Update Board</button>
                    <a href="{{ route('admin.forum.boards') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const isPublicCheckbox = document.getElementById('is_public');
    const accessControls = document.getElementById('access-controls');
    
    function toggleAccessControls() {
        if (isPublicCheckbox.checked) {
            accessControls.style.display = 'none';
        } else {
            accessControls.style.display = 'block';
        }
    }
    
    isPublicCheckbox.addEventListener('change', toggleAccessControls);
    toggleAccessControls(); // Initial state
});
</script>
@endsection